%IcRn from threshold method
%% set the default font size for all figure
set(0,'defaultAxesFontSize',20)

%% ask the user to load the file
uiwait(msgbox('Choose the file you want to analyze'))
[fileName,pathName,~] = uigetfile('*.dat', 'Open file .dat');

%% get the data by reading the file
file = importdata(fullfile(pathName,fileName));

%% ask for the current
prompt_current = 'enter the current module amplification in Amperes';
dlgtitle_current = 'Input';
user_val_current = inputdlg(prompt_current,dlgtitle_current);
current_val = str2num(user_val_current{1});

%% ask for the voltage
prompt_voltage = 'enter the Vmeasure module amplification in Volts';
dlgtitle_voltage = 'Input';
user_val_voltage = inputdlg(prompt_voltage,dlgtitle_voltage);
voltage_val = str2num(user_val_voltage{1});

%% ask for the gate voltage
prompt_gate_voltage = 'enter the amplification for the gate voltage in Volts';
dlgtitle_gate_voltage = 'Input';
user_val_gate_voltage = inputdlg(prompt_gate_voltage,dlgtitle_gate_voltage);
gate_voltage_val = str2num(user_val_gate_voltage{1});

%% Reading the size of Ibias
str_Ibias = char(file.textdata(6));
str_split = strsplit(str_Ibias);
size_Ibias = str2num(str_split{3});

%% Getting Ibias values
Ibias = file.data(1:size_Ibias,1)*current_val;

%% Reading the size of Vg
str_Vg = char(file.textdata(12));
str_split_Vg = strsplit(str_Vg);
%size_Vg = str2num(str_split_Vg{3});

size_Vg = length(file.data(:,1))/size_Ibias;

%% Getting the gate voltage
r=1;
for i=1:size_Vg
    Vg(i)=file.data(r,2);
    r=r+size_Ibias;
end

%% Getting measured Voltage values
s=1;
Vmeasure = zeros(size_Vg,size_Ibias);
for i=1:size_Vg
    Vmeasure(i,1:size_Ibias)=file.data(s:s+size_Ibias-1,4)*voltage_val;
    s=s+size_Ibias;
end

%% calculating the differential resistance in Ohms
dVdI = zeros(size_Vg,size_Ibias);
for i=1:size_Vg
    for j=2:size_Ibias-1
        dVdI(i,j) = (Vmeasure(i,j+1)-Vmeasure(i,j-1))/(Ibias(j+1)-Ibias(j-1));
    end
end

dVdI_choose = zeros(size_Vg,size_Ibias);
for i=1:size_Vg
    for j=2:size_Ibias-1
        dVdI_choose(i,j) = dVdI(i,j)-dVdI(i,(size_Ibias+1)/2);
    end
end

%figure;
x_axis = Vg*gate_voltage_val;%in volts
y_axis = Ibias(2:end-1)*10^6;%in uA
z_axis = transpose(dVdI(:,2:end-1));
z_axis1 = transpose(dVdI_choose(:,2:end-1));
l_size_1  = size(z_axis,1);
l_size_2  = size(z_axis,2);

for j=1:size_Vg
    for k=(size_Ibias+1)/2:1:size_Ibias-2
        if z_axis1(k,j)>5%BL2_4
            Ic(j) = y_axis(k);
            break;
        end
    end          
end

% for j=1:size_Vg
%     for k=(size_Ibias+1)/2:1:size_Ibias-2
%         if z_axis(k,j)>1600%BL2_5
%             Ic(j) = y_axis(k);
%             break;
%         end
%     end          
% end

% for j=1:size_Vg
%     for k=(size_Ibias+1)/2:1:size_Ibias-2
%         if z_axis(k,j)>900%BR2_4,datS_11872
%             Ic(j) = y_axis(k);
%             break;
%         end
%     end          
% end

% for j=1:size_Vg
%     for k=(size_Ibias+1)/2:1:size_Ibias-2
%         if z_axis1(k,j)>100%BR2_2,Chip2
%             Ic(j) = y_axis(k);
%             break;
%         end
%     end          
% end

% for j=1:size_Vg
%     for k=(size_Ibias+1)/2:1:size_Ibias-2
%         if z_axis1(k,j)>1%BR2_7,Chip2
%             Ic(j) = y_axis(k);
%             break;
%         end
%     end          
% end

Rn = dVdI(:,end-1);
R0=dVdI(:,(size_Ibias+1)/2);
R_true=Rn-R0;
for i=1:size_Vg
    IcRn(i)=-Ic(i)*(Rn(i)-R0(i));
end

% figure
% subplot(2,1,1);
% plot(x_axis(1:size_Vg-1),IcRn(1:size_Vg-1))
% ylabel('$I_{c}R_{n}(\mu V)$','Interpreter','latex');
% subplot(2,1,2);
% plot(x_axis(1:size_Vg-1),-Ic(1:size_Vg-1)*1000)
% ylabel('$I_{c}(nA)$','Interpreter','latex');
% xlabel('$V_{g}(V)$','Interpreter','latex')

figure
yyaxis left
plot(x_axis(1:size_Vg-1),IcRn(1:size_Vg-1))
ylabel('$I_{c}R_{n}(\mu V)$','Interpreter','latex');
yyaxis right
plot(x_axis(1:size_Vg-1),-Ic(1:size_Vg-1)*1000)
ylabel('$I_{c}(nA)$','Interpreter','latex');
xlabel('$V_{g}(V)$','Interpreter','latex')